taskID <- as.integer(Sys.getenv("SLURM_ARRAY_TASK_ID"))
#taskID <- 1
require(Matrix)
#require(Beta)

#taskID <- 1

epsilon = c(0.3,0.3, 0.3)
prop = c(0.6,0.6,0.6)

sim_grid <- expand.grid(epsilon, prop)

#block_params <- sim_grid[as.integer((taskID-1000)/100)+1,]
block_params <- sim_grid[as.integer(taskID/100)+1,]


Np = c(5,10, 15)
N = c(1000,5000,10000)

sim_grid <- expand.grid(Np, N)

#pop_params <- sim_grid[as.integer((taskID-1000)/100)+1,]
pop_params <- sim_grid[as.integer(taskID/100)+1,]

#Generate Graph
symm_binom_graph <- function(N,prob){
  connects <- rbinom(N*N, 1, prob)
  assym_graph <- Matrix(connects, N, N, sparse = T) * as.numeric(lower.tri(diag(N), diag = F))
  assym_graph_trans <- t(assym_graph) + assym_graph
  return(assym_graph_trans)
}


#symm_beta_binom_graph <- function(N,prob){
#  alpha <- 1
#  beta <- (alpha*(1-prob))/prob
#  probs <- rbeta(N*N, alpha, beta)
#  connects <- rbinom(N*N, 1, probs)
#  print(var(connects))
#  assym_graph <- Matrix(connects, N, N, sparse = T) * as.numeric(lower.tri(diag(N), diag = F))
#  assym_graph_trans <- t(assym_graph) + assym_graph
#  return(assym_graph_trans)
#} - actually the same as bernoulli prob!


stochastic_block_graph <- function(N, prob, prop, epsilon){
  
  group_mem <- rbinom(N, 1, prop)
  #the two groups
  n_A = sum(group_mem)
  n_B = N-n_A
  #ratio between in_prob and out_prob
  
  in_out_min  = max(0,(prob*N*(N-1) - ( n_A*(n_A-1) + n_B*(n_B -1) ) )/(2*n_A*n_B))
  print(in_out_min)
  in_out = in_out_min + (1-in_out_min)*epsilon
  print(in_out)
  
  #calculation of in_prob based on overall prevalence
  in_prob <- (prob*N*(N-1) )/(2*in_out*n_A*n_B + ( n_A*(n_A-1) + n_B*(n_B -1) ))
  out_prob <- in_prob*in_out
  print(in_prob)
  print(out_prob)

  
  #form building block matrices using in and out probs
  in_connects <- rbinom(N*N, 1, in_prob)
  in_matrix <- Matrix(in_connects, N, N, sparse = T)
  out_connects <- rbinom(N*N, 1, out_prob)
  out_matrix <- Matrix(out_connects, N, N, sparse = T)
  
  in_group_matrix <- in_matrix * Matrix(group_mem %*% t(group_mem) +
                                          (1-group_mem) %*% t(1-group_mem), sparse = T)
  
  #print(sum(in_group_matrix)/(n_A^2 + n_B^2))
  
  bet_group_matrix <- out_connects * Matrix((1-group_mem) %*% t(group_mem) + 
                                              (group_mem) %*% t(1-group_mem), sparse = T)
  
  #print(sum(bet_group_matrix)/(2*n_A*n_B))
  
  assym_graph <- (in_group_matrix + bet_group_matrix) * as.numeric(lower.tri(diag(N), diag = F))
  sym_graph <- t(assym_graph) + assym_graph
  print("stochastic block")
  print(mean(sym_graph))
  return(list(in_prob = in_prob, out_prob = out_prob, 
              sym_graph = sym_graph, group_mem = group_mem))
}






best_RDS_sample_craw_multiple_bare<- function(net, coupons, seeds, rate, interview_limit = NULL, covariates = NULL ){
  #Main automated RDS Sampler
  
  rec_cov <- NULL
  
  size = length(net[,1])
  
  if(is.null(interview_limit)){
    interview_limit = size
  }
  
  sample = T
  recruited <- seeds
  network_observed <- Matrix(NA, size,size)
  direction_network_observed <- Matrix(NA, size,size)
  coupon_vector <- rep(0, size)
  coupon_vector[seeds] <- coupons
  degrees <- rowSums(net) 
  wait_time_mat <- matrix(NA,size,size)
  #Insert wait times for all seed recruits
  
  #identify neighbors of seeds
  for (seed in seeds){
    
    #identify neighbors of the seed
    neighbors <- which(net[seed,] ==1)
    
    #check if potential recruits were already recruited
    potentials <-  neighbors[!(neighbors %in% recruited)]
    
    #generate wait times
    wait_times <- rexp(length(potentials), rate = rate)
    
    #add the wait times to the wait time matrix
    wait_time_mat[seed, potentials] <- wait_times
    
    
    #set the wait times going to recruited to NA
    wait_time_mat[,seed] <- NA
    
  }
  
  
  
  #store coupon matrix and times
  times <- rep(0,length(seeds))
  coupon_matrix <- Matrix(0,size, size)
  k <- length(seeds) + 1
  
  
  while (sample){
    
    
    #Fill in coupon matrix
    coupon_matrix[,k] <- as.numeric(coupon_vector > 0)
    
    
    #increment time
    k <- k+1
    
    # now let's pick out the next observed edge
    r_c <- which(min(wait_time_mat, na.rm = T) == wait_time_mat, arr.ind = T)
    time <- min(wait_time_mat, na.rm = T)
    
    #add time
    times <- c(times, time)
    
    #fill in RDS directed network
    direction_network_observed[r_c[1], r_c[2]] <- 1
    
    #fill in the observed edge in symmetric network
    network_observed[r_c[1], r_c[2]] <- 1
    network_observed[r_c[2], r_c[1]] <- 1
    
    #add recruited to recruited list
    recruited <- c(recruited, r_c[2])
    newly_recruited <- r_c[2]
    
    #Give coupons to recruited 
    coupon_vector[r_c[2]] <- coupons
    
    #subtract a coupon from the recruiter
    coupon_vector[r_c[1]] <-  coupon_vector[r_c[1]] - 1
    
    #set wait times associated with a node with no coupons to NA
    if(length(r_c) > 0){
      if(coupon_vector[r_c[1]] == 0){
        wait_time_mat[r_c[1],] <- NA
      }
    }
    
    #set the wait times going to recruited to NA
    wait_time_mat[,r_c[2]] <- NA
    
    #increment time
    wait_time_mat[!is.na(wait_time_mat)]<- wait_time_mat[!is.na(wait_time_mat)] - time
    #print(wait_time_mat)
    
    #generate wait times for potential edges of newly recruited node
    
    #identify neighbors of newly_recruited
    neighbors <- which(net[newly_recruited,] ==1)
    
    #check if potential recruits were already recruited
    potentials <-  neighbors[!(neighbors %in% recruited)]
    
    #generate wait times
    wait_times <- rexp(length(potentials), rate = rate)
    
    #add the wait times to the wait time matrix
    wait_time_mat[newly_recruited, potentials] <- wait_times
    
    #print(wait_time_mat)
    
    #print(recruited)
    #print(coupon_vector)
    
    sample = !( all(coupon_vector==0) |
                  all(is.na(wait_time_mat)) | 
                  length(recruited) >= interview_limit )
    
  }
  
  
  #arrange the coupon matrix and cut off time at last recruitment event
  final_coupon_matrix <- coupon_matrix[recruited,1:length(recruited)]
  
  #let's rearrange the observed network so it lines up with the recruitment order
  network_recruited <- network_observed
  network_recruited[which(is.na(network_observed))] <- 0 
  network_recruited <- network_recruited[recruited,recruited]
  
  #true network
  true_network <- net[recruited, recruited]
  
  #covariates of recruited participants
  if(!is.null(covariates)){
    rec_cov <- covariates[recruited]
  }
  
  return(list(rec_cov = rec_cov,
              true_network = true_network, 
              #network = network_observed,
              network_recruited = network_recruited, 
              recruited = recruited, 
              coupon_vector = coupon_vector, 
              times = times,
              #wait_time_mat = wait_time_mat, 
              #direction_network_observed = direction_network_observed,
              degrees = degrees, 
              #coupon_matrix = coupon_matrix, 
              final_coupon_matrix = final_coupon_matrix, seeds = seeds,k=k ))
}



#READ IN DATA AND SIMULATE TIMES

#block params
epsilon <- as.double(block_params[1])
prop <- as.double(block_params[2])

stochastic_block = T #SENSITIVITY
if(stochastic_block){
  N= 5000
  prob = 0.002
  true_total_graph_results <- stochastic_block_graph(N, prob, prop, epsilon)
  true_total_graph <- true_total_graph_results$sym_graph
  in_prob <- true_total_graph_results$in_prob
  out_prob <- true_total_graph_results$out_prob
  group_mem <- true_total_graph_results$group_mem
}else{
  N<- as.double(pop_params[2])
  prob <- as.double(pop_params[1]/pop_params[2])
  true_total_graph <- symm_binom_graph(N,prob)
  in_prob <- F
  out_prob <- F
  group_mem <- NA
}


rds <- best_RDS_sample_craw_multiple_bare(true_total_graph, 5, sample(1:N, 3), 1, 
                                          interview_limit = 100, 
                                          covariates = NULL)

saveRDS(list(rds = rds, in_prob = in_prob, out_prob = out_prob, group_mem = group_mem[rds$recruited], group_mem_total = group_mem) , paste0('rds_', taskID, '.rds')) 
